package furny.swing.admin.statistics.chart;

import java.util.Map.Entry;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import furny.ga.logger.DataCache;

/**
 * The Class MeanFitnessGenerationChart. The charts are just experimental and
 * not documented yet.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class MeanFitnessGenerationChart implements IChartSettings {
  @Override
  public JFreeChart createChart(final long runId) {
    final XYSeries series = new XYSeries("Fitness(mean) over generations");

    for (final Entry<Long, Double> entry : DataCache.getInstance()
        .getMeanFitnessGenerations(runId).entrySet()) {
      series.add(entry.getKey(), entry.getValue());
    }

    final XYDataset xyDataset = new XYSeriesCollection(series);

    final JFreeChart chart = ChartFactory.createXYLineChart(null, // Title
        "Generation", // X-Axis label
        "Fitness", // Y-Axis label
        xyDataset, // Dataset
        PlotOrientation.VERTICAL, //
        true, // Show legend
        true, // show tooltips
        false); // show urls

    // final XYPlot plot = (XYPlot) chart.getPlot();
    //
    // final NumberAxis na = (NumberAxis) plot.getDomainAxis();
    // na.setTickUnit(new NumberTickUnit(1d));
    // na.setRangeType(RangeType.POSITIVE);

    // plot.setRenderer(ChartUtil.getLineRenderer());

    return chart;
  }

  @Override
  public String toString() {
    return "Fitness(mean) / Generations";
  }
}
